// 24BitIntervalTimerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "24BitIntervalTimer.h"
#include "24BitIntervalTimerDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMy24BitIntervalTimerDlg dialog

CMy24BitIntervalTimerDlg::CMy24BitIntervalTimerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMy24BitIntervalTimerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMy24BitIntervalTimerDlg)
	m_status = _T("");
	m_interval = 0.0f;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMy24BitIntervalTimerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMy24BitIntervalTimerDlg)
	DDX_Control(pDX, IDC_STOP, m_stop);
	DDX_Control(pDX, IDC_START, m_start);
	DDX_Text(pDX, IDC_STATUS, m_status);
	DDX_Text(pDX, IDC_INTERVAL, m_interval);
	DDV_MinMaxFloat(pDX, m_interval, 5.f, 419.f);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMy24BitIntervalTimerDlg, CDialog)
	//{{AFX_MSG_MAP(CMy24BitIntervalTimerDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_OPEN_DRIVER, OnOpenDriver)
	ON_BN_CLICKED(IDOK, OnExit)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_BN_CLICKED(IDC_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMy24BitIntervalTimerDlg message handlers

BOOL CMy24BitIntervalTimerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_driverInstance = NULL;  // set our variables equal to something
	m_pSR = NULL;
	ticCounter = 0;
	m_interval = 100;
	UpdateData(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMy24BitIntervalTimerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMy24BitIntervalTimerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMy24BitIntervalTimerDlg::OnOpenDriver() 
{

/*
This program was written in Win2K SP1 with 3140-850A02 version of 
DriverLINX for KPCI-3140 board.

It demonstrates programming one of the 24bit interval counters for
generation of an interrupt at requested intervals.  The application
will recieve a TimerTic message from DriverLINX when the requested
interval has elapsed.

*/
	   // Open the driver and Initialize the hardware

// pass in driver name to avoid the Open DriverLINX Dialog
m_driverInstance=OpenDriverLINX(m_hWnd,"kpci3140"); //Open DriverLINX driver, and bring up the dialog box to pick a driver
m_pSR=(DL_ServiceRequest*) new (DL_ServiceRequest); //get a pointer to the service request
memset(m_pSR,0,sizeof(DL_ServiceRequest)); //Initialize the members of the service request
DL_SetServiceRequestSize(*m_pSR); //Need to set the service request size member
//
// initialize the hardware of this kpci3140 family
//
m_pSR->device=0; //set the device number (DriverLINX Config Panel setting)
m_pSR->operation=INITIALIZE; //Need to initialize the device before we can use it
m_pSR->subsystem=DEVICE;  //the initialize function is part of the DEVICE subsystem
m_pSR->mode=OTHER;  //Initialize is not a polled, interrupt, or dma operation, so we use OTHER
m_pSR->hWnd=m_hWnd;  //Need to set the hWnd member to the window handle of the application
//Execute the initialize service
 //show any errors	

if (DriverLINX(m_pSR) == NoErr)
{
	// success
m_start.EnableWindow(TRUE);  // enable the Sample button
UpdateData(FALSE);
m_DLmsg=RegisterWindowMessage(DL_MESSAGE);  // get a safe offset for our DriverLINX messages
}
else
{  // problem has occured
showMessage(m_pSR);  // display the error message box

}


// if used, open the driver and Init the second SR structure:	

// set focus back to our dialog
CWnd::SetActiveWindow();
}

void CMy24BitIntervalTimerDlg::showMessage(DL_ServiceRequest *SR)
{
	SR->operation=MESSAGEBOX;
	DriverLINX(SR);
/*
// the code below could be used instead of the messagebox operation above

char errString[100];
DWORD size=50;
int errNumber;
errNumber = getErrCode(SR->result);
// errNumber corresponds to DriverLINX documentation
ReturnMessageString(SR->hWnd,SR->result,errString,size);
// errString corresponds to DriverLINX documentation
m_errMsg.Format("%s",errString);  // would need to add a static text called m_errMsg to dialog
UpdateData(FALSE);  // update the dialog
*/

	return;
}

void CMy24BitIntervalTimerDlg::OnExit() 
{
	// stop any active tasks.....
m_pSR->taskId = m_taskID;
m_pSR->operation=STOP;	
DriverLINX(m_pSR);
	// close driver and release memory
	if (m_driverInstance != NULL)
{
   CloseDriverLINX(m_driverInstance); //close the DriverLINX driver
   m_driverInstance=NULL; //make sure m_driverInstance isn't pointing to anything
}
if (m_pSR != NULL)
{

   delete(m_pSR); //de-allocate the memory used by the service request
   m_pSR=NULL;
}


// now do same for the second Service Request if used

CMy24BitIntervalTimerDlg::DestroyWindow(); // close the window
	
}

void CMy24BitIntervalTimerDlg::OnStop() 
{
	/*
  if we do a STOP operation on a task that does not exist, an error will result.
  this app does not do any error checking for this condition.
*/
// stop first task
m_pSR->taskId = m_taskID;
m_pSR->operation=STOP;	
DriverLINX(m_pSR);

m_stop.EnableWindow(FALSE);  // disable the Stop button
m_start.EnableWindow(TRUE);  // enable the Start button
	
}

void CMy24BitIntervalTimerDlg::OnStart() 
{
/*
' program the rate at which the counters will elapse......
rateEvent.period = Secs2Tics(deviceNumber,CT,INTERNAL1,interval)

' internal1 timebase is 40MHz.  rateChannel 8 is a 24bit counter.
' 40MHz / 2^24 = 2.38 Hz => 419 msec is the slowest you can go.....
'
' how fast can you go?  how fast can TimerTic Windows' messages be processed?
' not practical to go faster than about 1KHz

*/
	UpdateData(TRUE);  // need to read in the requested interval from the dialog
	float interval;
	interval = (float) m_interval / 1000; // convert to milli seconds

	m_stop.EnableWindow(TRUE);
    UpdateData(FALSE); //update the dialog

	m_pSR->operation=START;
	m_pSR->subsystem=CT;
	m_pSR->mode=INTERRUPT;
	m_pSR->start.typeEvent=COMMAND;
	m_pSR->stop.typeEvent= COMMAND; //Remain active until the stop button is pressed
	m_pSR->timing.typeEvent=RATEEVENT;
	m_pSR->timing.u.rateEvent.channel=8; // chan 8, 9, 10 and 11 are internal 24bit counters
	// channels 0 through 7 are the general purpose 16bit counters
	m_pSR->timing.u.rateEvent.mode=RATEGEN; //Set the counter/timer mode to burst generation
	m_pSR->timing.u.rateEvent.clock=INTERNAL1;  //External clocking will be used
	m_pSR->timing.u.rateEvent.gate=DISABLED; //no gating will be used
	m_pSR->timing.u.rateEvent.period=Sec2Tics(0,CT,INTERNAL1,interval); //
	m_pSR->timing.u.rateEvent.pulses=0; //
	DriverLINX(m_pSR); //Start the task
	showMessage(m_pSR); //show any errors

	m_taskID=m_pSR->taskId; //Need to save the task ID so we can identify it later
	                        // in the TimerTic message (message pump)
	
}

LRESULT CMy24BitIntervalTimerDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
		if(message==m_DLmsg) //Did DriverLINX post a message?
	{
		switch(wParam)
		{
		case DL_TIMERTIC: //Check for which task is responsible for this TimerTic message
			WORD taskID;
			taskID = getTaskId(lParam);  // this is a DriverLINX macro to decode the info
			if (m_taskID == taskID)
			{   // in case program design will use multiple tasks that will each send
				// TimerTic message, test for which task is sending the message
				  CString str;
				  char message[40];
				  strcpy(message,"Timer has elapsed ");
				  ticCounter = ticCounter + 1;
				  str.Format("%d",ticCounter);
	              strcat(message,str);  // tack ticCounter onto end of message
				  strcat(message," times");
	              m_status.Format("%s",message);
				  UpdateData(FALSE); //update the dialog
			} 
			break;
        case DL_SERVICEDONE:
            m_status.Format("%s","Task is inactive....");
			UpdateData(FALSE); //update the dialog
			break;
		}
	}
	
	return CDialog::WindowProc(message, wParam, lParam);
}


